<?php
function theme_setup() {
    // تسجيل قوائم الناڤيجيشن
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'theme-textdomain'),
        'footer'  => __('Footer Menu', 'theme-textdomain')
    ));

    // دعم الصور المصغرة
    add_theme_support('post-thumbnails');

    // دعم عنوان الصفحة
    add_theme_support('title-tag');

    // دعم الشعار المخصص
    add_theme_support('custom-logo', array(

    ));
}
add_action('after_setup_theme', 'theme_setup');

function load_style()
{


    wp_enqueue_style('swiper', get_template_directory_uri() . '/css/swiper.css');
    wp_enqueue_style('fancy', get_template_directory_uri() . '/css/jquery.fancybox.min.css');
    wp_enqueue_style('animate', get_template_directory_uri() . '/css/animate.min.css');
    wp_enqueue_style('master', get_template_directory_uri() . '/css/master.min.css');
    if (get_locale() === 'ar') {
        wp_enqueue_style('ar', get_template_directory_uri() . '/css/ar.css');

    }


    wp_deregister_script('jquery');
    wp_enqueue_script('jquery', get_template_directory_uri() . '/js/jquery-3.4.1.min.js', array(), null, true);
    wp_enqueue_script('popper', get_template_directory_uri() . '/js/popper.min.js', array(), null, true);
    wp_enqueue_script('bootstraping', get_template_directory_uri() . '/js/bootstrap.min.js', array(), null, true);
    wp_enqueue_script('swiperjs', get_template_directory_uri() . '/js/swiper.min.js', array(), null, true);
    wp_enqueue_script('typed', get_template_directory_uri() . '/ajax/libs/typed.js/1.1.1/typed.min.js', array(), null, true);
    wp_enqueue_script('easy', get_template_directory_uri() . '/js/jquery.easypiechart.min.js', array(), null, true);

    wp_enqueue_script('mixtup', get_template_directory_uri() . '/ajax/libs/mixitup/2.1.11/jquery.mixitup.js', array(), null, true);
    wp_enqueue_script('lazy', get_template_directory_uri() . '/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.min.js', array(), null, true);
    wp_enqueue_script('lazy2', get_template_directory_uri() . '/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.plugins.min.js', array(), null, true);
    wp_enqueue_script('scripts', get_template_directory_uri() . '/js/scripts-min.js', array(), null, true);
}

add_action('wp_enqueue_scripts', 'load_style');
function create_skill_post_type() {
    register_post_type('skills',
        array(
            'labels' => array(
                'name' => __('المهارات'),
                'singular_name' => __('Skill')
            ),
            'public' => true,
            'has_archive' => true,
            'rewrite' => array('slug' => 'skills'),
            'supports' => array('title', 'editor', 'thumbnail')
        )
    );
}
add_action('init', 'create_skill_post_type');


// أضف حقول ميتا للمهارات
function add_skills_meta_boxes() {
    add_meta_box(
        'skills_details',       // ID of the meta box
        'تفاصيل المهارة',       // Title of the meta box
        'skills_meta_box_html', // Callback function
        'skills',               // Post type
        'normal',               // Context
        'default'               // Priority
    );
}
add_action('add_meta_boxes', 'add_skills_meta_boxes');

// HTML for the meta box
function skills_meta_box_html($post) {
    $percent = get_post_meta($post->ID, 'percentage', true);
    $color = get_post_meta($post->ID, 'bar_color', true);

    ?>
    <div>
        <label for="percentage">النسبة المئوية:</label>
        <input type="text" name="percentage" id="percentage" value="<?php echo esc_attr($percent); ?>" class="widefat">
    </div>
    <div>
        <label for="bar_color">لون الشريط:</label>
        <input type="color" name="bar_color" id="bar_color" value="<?php echo esc_attr($color); ?>">
    </div>
    <?php
}

// Save the meta box content
function save_skills_meta_box($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    if (array_key_exists('percentage', $_POST)) {
        update_post_meta($post_id, 'percentage', sanitize_text_field($_POST['percentage']));
    }
    if (array_key_exists('bar_color', $_POST)) {
        update_post_meta($post_id, 'bar_color', sanitize_hex_color($_POST['bar_color']));
    }
}
add_action('save_post', 'save_skills_meta_box');


function create_service_post_type() {
    register_post_type('services',
        array(
            'labels' => array(
                'name' => __('الخدمات'),
                'singular_name' => __('خدمة')
            ),
            'public' => true,
            'has_archive' => true,
            'rewrite' => array('slug' => 'services'),
            'supports' => array('title', 'editor', 'thumbnail') // تأكد من وجود 'thumbnail' هنا
        )
    );
}
add_action('init', 'create_service_post_type');
function create_project_post_type() {
    register_post_type('project',
        array(
            'labels' => array(
                'name' => __('المشاريع'),
                'singular_name' => __('مشروع')
            ),
            'public' => true,
            'has_archive' => true,
            'rewrite' => array('slug' => 'projects'),
            'supports' => array('title', 'editor', 'thumbnail') // تأكد من إضافة 'thumbnail'
        )
    );
}
add_action('init', 'create_project_post_type');

function create_project_taxonomy() {
    register_taxonomy(
        'project_category',
        'project',
        array(
            'label' => __('أقسام المشروع'),
            'rewrite' => array('slug' => 'project-category'),
            'hierarchical' => true,
        )
    );
}
add_action('init', 'create_project_taxonomy');

function create_testimonial_post_type() {
    $args = array(
        'labels' => array(
            'name' => 'التقيمات',
            'singular_name' => 'Testimonial'
        ),
        'public' => true,
        'has_archive' => true,
        'supports' => array('title', 'editor', 'thumbnail')
    );
    register_post_type('testimonial', $args);
}
add_action('init', 'create_testimonial_post_type');

function add_stars_taxonomy() {
    register_taxonomy(
        'stars',
        'testimonial',
        array(
            'label' => 'Stars',
            'rewrite' => array('slug' => 'stars'),
            'hierarchical' => true,
        )
    );
}
add_action('init', 'add_stars_taxonomy');
function add_custom_meta_boxes() {
    add_meta_box('testimonial_color', 'Color for Stars', 'testimonial_color_callback', 'testimonial', 'side', 'default');
}

function testimonial_color_callback($post) {
    $color = get_post_meta($post->ID, 'star_color', true);
    echo '<label for="star_color">Choose Color:</label>';
    echo '<input type="color" id="star_color" name="star_color" value="' . esc_attr($color) . '">';
}

add_action('add_meta_boxes', 'add_custom_meta_boxes');

function save_testimonial_meta($post_id) {
    if (array_key_exists('star_color', $_POST)) {
        update_post_meta($post_id, 'star_color', $_POST['star_color']);
    }
}

add_action('save_post', 'save_testimonial_meta');
function include_jquery() {
    wp_enqueue_script('jquery');
}
add_action('wp_enqueue_scripts', 'include_jquery');

add_filter('auto_update_core', '__return_true');
add_filter('automatic_updater_disabled', '__return_false');





