<?php $bn = get_field('bn'); ?>
<?php
/*
Template Name: work Template
*/
?>
<?php get_header(); ?>
<section>
    <div class="page-header"><img src="<?php echo $bn; ?>" alt="">
        <div class="title">
            <h1>معرض أعمالي</h1>
            <ul class="breadcrumb">
                <li><a href="<?php echo esc_url(home_url('/')); ?>">الرئيسية </a></li>
                <li>معرض أعمالى </li>
            </ul>
        </div>
    </div>
</section>
<?php
$args = array(
    'post_type' => 'project',
    'posts_per_page' => 10, // يمكن تعديل عدد المشاريع المعروضة
    'orderby' => 'date',
    'order' => 'DESC'
);

$projects_query = new WP_Query($args);

if ($projects_query->have_posts()): ?>
    <section>
        <div class="portfolio n-port n-sec" id="portfolio">
            <div class="container">

                <div class="portfolio-content">


                    <div id="Container">
                        <div class="row">
                            <?php while ($projects_query->have_posts()):
                                $projects_query->the_post();
                                $project_categories = get_the_terms(get_the_ID(), 'project_category');
                                $class_list = [];
                                if (!empty($project_categories)) {
                                    foreach ($project_categories as $cat) {
                                        $class_list[] = $cat->slug;
                                    }
                                }
                                $project_link = get_post_meta(get_the_ID(), 'Project_Link', true);
                                $new = get_post_meta(get_the_ID(), 'new', true);
                                ?>
                                <div class="mix col-md-4 col-sm-6 col-12 <?php echo implode(' ', $class_list); ?>"
                                    data-myorder="1">
                                    <div class="img">
                                        <?php if (has_post_thumbnail()): ?>
                                            <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                                        <?php endif; ?>
                                        <div class="hover">
                                            <div class="content">
                                                <div class="btns">
                                                    <a href="<?php the_post_thumbnail_url(); ?>" data-fancybox="gallery"><i
                                                            class="fas fa-search-plus"></i></a>
                                                    <a href="<?php echo esc_url($project_link); ?>" target="_blank"><i
                                                            class="fas fa-link"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="title">
                                        <h3><?php the_title(); ?></h3>
                                        <p><?php echo implode(', ', wp_list_pluck($project_categories, 'name')); ?></p>
                                    </div>
                                    <span class="badge badge-success"><?php echo esc_html($new); ?></span>

                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>


















<?php get_footer(); ?>